

function dutchrat_weapon_check(player) {
    let valid = false
    let mainhand = player.mainHandItem
    let offhand = player.offHandItem
    if (offhand.id == 'cgm:mini_gun' || mainhand.id == 'cgm:mini_gun') {
        valid = true
    }
    return valid
}

function dutchrat_vehicle_check(player) {
    let valid = false
    if (player.rootVehicle.type == 'alexscaves:subterranodon') {
        valid = true
    }
    return valid
}

function dutchrat_baron_check(player) {
    let valid = false
    if (player.level.getEntities().filter(e => e.type == 'rats:rat_baron').length == 0) {
        valid = true
    } else {
        let chance = Math.random()
        if (chance < 0.25) {
            player.tell('The Dutchrat is protected by the lifeforce of the Rat Barons.')
        }
        valid = false

    }
    return valid
}


function dutchrat_check(player) {
    let valid = false
    let valid_weapon = dutchrat_weapon_check(player)
    let valid_vehicle = dutchrat_vehicle_check(player)
    let valid_baron = dutchrat_baron_check(player)
    if (valid_weapon && valid_vehicle && valid_baron) {
        valid = true
    }
    return valid
}


EntityEvents.death('player', event => {
    if (!event.entity.tags.contains('dutchrat_summoned')) return
    let player = event.entity
    if (player.level.dimension != 'rats:ratlantis') return
    player.tags.remove('dutchrat_summoned')
    player.persistentData.remove('subterranodon_uuid')
    player.persistentData.remove('dutchrat_summoned')
    player.persistentData.remove('dutchrat_bell_x')
    player.persistentData.remove('dutchrat_bell_y')
    player.persistentData.remove('dutchrat_bell_z')
    player.persistentData.remove('dutchrat_bell_dim')

})



EntityEvents.hurt('rats:dutchrat', event => {
    if (event.source.toString().includes('genericKill')) return
    if (!event.source.player) {
        event.cancel()
        return
    }
    let player = event.source.player
    
    let valid = dutchrat_check(player)
    if (!valid) {
        event.cancel()
    } else {
        player.mainHandItem.nbt.merge({
            AmmoCount: 100,
        })
        player.offHandItem.nbt.merge({
            AmmoCount: 100,
        })
        player.mainHandItem.damageValue = 0
        player.offHandItem.damageValue = 0
    }
    let chance = Math.random()
    if (chance < 0.50) return
    let entity = event.entity
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y+1} ${entity.z} 0.2 0.2 0.2 0.2 50`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 0.7 1`)

})


EntityEvents.hurt('rats:rat_baron', event => {
    if (event.source.toString().includes('genericKill')) return
    if (!event.source.player) {
        event.cancel()
        return
    }
    let player = event.source.player
    let valid = dutchrat_weapon_check(player) && dutchrat_vehicle_check(player) && player.mainHandItem.nbt != null
    if (!valid) {
        return
    } else {
        player.mainHandItem.nbt.merge({
            AmmoCount: 100,
        })
        player.offHandItem.nbt.merge({
            AmmoCount: 100,
        })
        player.mainHandItem.damageValue = 0
        player.offHandItem.damageValue = 0
    }
    let chance = Math.random()
    if (chance < 0.50) return
    let entity = event.entity
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:blood ${entity.x} ${entity.y+1} ${entity.z} 0.2 0.2 0.2 0.2 25 force @a`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexsmobs:fly_hurt ambient ${player.username} ${entity.x} ${entity.y+1} ${entity.z} 0.7 0.9`)
})


BlockEvents.rightClicked('rats:dutchrat_bell', event => {
    let player = event.player
    if (!player.mainHandItem.empty) {
        player.tell('You must have an empty hand to ring the bell.')
        event.cancel()
        return
    }
    event.server.persistentData.putInt('dutchrat_bell_x', parseInt(player.x))
    event.server.persistentData.putInt('dutchrat_bell_y', parseInt(player.y) + 2)
    event.server.persistentData.putInt('dutchrat_bell_z', parseInt(player.z))
    event.server.persistentData.putString('dutchrat_bell_dim', player.level.dimension)
})


function spawnBaron(dutchrat) {
    // random number between -30 and 30
    let randomX = Math.floor(Math.random()*60)-30
    let randomZ = Math.floor(Math.random()*60)-30
    Utils.server.runCommandSilent(`/execute in ${dutchrat.level.dimension} run summon rats:rat_baron ${dutchrat.x+randomX} ${dutchrat.y+25} ${dutchrat.z+randomZ}`)
}
//event.entity.playSound('cataclysm:abyss_blast', 10, 2)


function spawnSubterranodon(player) {
    Utils.server.runCommandSilent(`execute as ${player.username} run playsound cataclysm:abyss_blast ambient @s ${player.x} ${player.y} ${player.z} 10 2`)
    Utils.server.scheduleInTicks(40, () => {
        player.potionEffects.add('minecraft:levitation', 40, 20)
        Utils.server.scheduleInTicks(40, () => {
            let subterranodon = player.level.createEntity('alexscaves:subterranodon')
            subterranodon.setPosition(player.x, player.y, player.z)
            subterranodon.mergeNbt({
                Owner: player.username,
                Attributes: [{
                    Name: 'minecraft:generic.movement_speed',
                    Base: 0.3
                }],
                Tags: ['dutchrat_subterranodon', 'Owner:'+player.username]
            })
            subterranodon.spawn()
            player.persistentData.putString('subterranodon_uuid', subterranodon.uuid)
            player.startRiding(subterranodon)
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark 0 1 2 ${subterranodon.x} ${subterranodon.y} ${subterranodon.z} 0.2 0.2 0.2 0.3 120`)
            subterranodon.playSound('irons_spellbooks:entity.chain_lightning.lightning_chain', 10, 1)
        })
    })
}


function dutchrat_subterranodon_spawn(player) {
    if (player.persistentData.get('subterranodon_uuid')) {
        let subterranodon_uuid = player.persistentData.getString('subterranodon_uuid')
        let subterranodon = player.level.getEntity(subterranodon_uuid)
        if (subterranodon == null || !subterranodon.alive || player.distanceToEntity(subterranodon) > 25) {
            Utils.server.runCommandSilent(`/kill ${subterranodon_uuid}`)
            player.persistentData.remove('subterranodon_uuid')
            dutchrat_subterranodon_spawn(player)
            return
        }
    } else {
        let creature = player.level.createEntity('alexscaves:subterranodon')
        creature.setPosition(player.x, player.y, player.z)
        creature.mergeNbt({
            Owner: player.username,
            Attributes: [{
                Name: 'minecraft:generic.movement_speed',
                Base: 0.3
            }],
            Tags: ['dutchrat_subterranodon', 'Owner:'+player.username]
        })
        creature.spawn()
        player.persistentData.putString('subterranodon_uuid', creature.uuid)
        player.startRiding(creature)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle irons_spellbooks:spark 0 1 2 ${creature.x} ${creature.y} ${creature.z} 0.2 0.2 0.2 0.3 120`)
        creature.playSound('irons_spellbooks:entity.chain_lightning.lightning_chain', 10, 1)
    }
}

EntityEvents.hurt('alexscaves:subterranodon', event => {
    if (event.source.toString().includes('genericKill')) return
    if (!event.entity.tags.contains('dutchrat_subterranodon')) return
    if (event.level.dimension != 'rats:ratlantis') return
    if (event.level.getEntities().filter(e => e.type == 'rats:dutchrat').length == 0) return
    event.cancel()
})



ServerEvents.tick(event => {
    if (event.server.tickCount % 10 != 0) return
    if (!event.server.persistentData.get('dutchrat_fight')) return
    if (event.server.entities.filter(e => e.type == 'rats:dutchrat').length == 0) {
        event.server.persistentData['dutchrat_fight'] = false
        return
    } else {
        event.server.persistentData.putBoolean('dutchrat_fight', true)
    }
    if (event.server.persistentData.getBoolean('dutchrat_fight') == false) return
    let players = event.server.getPlayers().filter(p => p.level.dimension == 'rats:ratlantis')
    if (players.length == 0) return
    players.forEach(player => {
        if (player.rootVehicle == null || player.rootVehicle.type != 'alexscaves:subterranodon') {
            dutchrat_subterranodon_spawn(player)
        }
    })
        

})

EntityEvents.spawned('rats:dutchrat', event => {
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run weather thunder`)
    event.entity.mergeNbt({
        Attributes: [{
            Name: 'minecraft:generic.movement_speed',
            Base: 0.5
        }],
    })
    event.server.persistentData.putString('dutchrat_uuid', event.entity.uuid)
    let players = event.level.getEntities().filter(e => e.isPlayer() && e.distanceToEntity(event.entity) < 100)
    if (players.length == 0) return
    players.forEach(p => {
        let player = event.server.getPlayer(p.uuid)
        //player.setMainHandItem(Item.of('cgm:mini_gun', '{AmmoCount:99}').enchant('minecraft:vanishing_curse', 1))
        player.tags.add('dutchrat_summoned')
        Utils.server.scheduleInTicks(120, () => {
            spawnSubterranodon(player)
            Utils.server.scheduleInTicks(80, () => {
                event.server.persistentData.putBoolean('dutchrat_fight', true)
                spawnBaron(event.entity)
            })
        })
    })
})





EntityEvents.hurt('rats:dutchrat', event => {
    if (!event.source.player) return
    let dutchrat = event.entity
    if (dutchrat.health <= dutchrat.maxHealth*0.75) {
        if (!dutchrat.tags.contains('75')) {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run time set midnight`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run weather thunder`)
            dutchrat.tags.add('75')
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
        }

    }
    if (dutchrat.health <= dutchrat.maxHealth*0.5) {
        if (!dutchrat.tags.contains('50')) {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run time set midnight`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run weather thunder`)
            dutchrat.tags.add('50')
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
        }

    }
    if (dutchrat.health <= dutchrat.maxHealth*0.25) {
        if (!dutchrat.tags.contains('25')) {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run time set midnight`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run weather thunder`)
            dutchrat.tags.add('25')
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
        }

    } 
    if (dutchrat.health <= dutchrat.maxHealth*0.1) {
        if (!dutchrat.tags.contains('10')) {
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run time set midnight`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run weather thunder`)
            dutchrat.tags.add('10')
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
            spawnBaron(dutchrat)
        }

    }
})



let dutchrat_attack_spells1 = [
    'wisp',
    'fireball',
    'blood_step',
    'blood_step',

    'despair',
    'despair',
]

let dutchrat_attack_spells2 = [
    'firebolt',
    'ball_lightning',
    'firebolt',
    'ball_lightning',

    'blood_step',
    'blood_step',


    'despair',
    'despair',
    
]

let dutchrat_defensive_spells = [
    'shield',
    'shield',
    'blood_step',
    'blood_step',
    'despair',
    'despair',
    
    'lightning_lance',
    'lightning_lance',

    'blaze_storm',
    'blaze_storm',
    'blaze_storm',
    'blaze_storm',
    'blaze_storm',
    'blaze_storm',
    
]

EntityEvents.hurt('rats:dutchrat', event => {
    if (!event.source.player) return
    // 5% chance to cast a spell
    let chance = Math.random()
    if (chance > 0.15) return
    let spells = dutchrat_defensive_spells
    //choose a number between 1 and 3
    let number = Math.floor(Math.random()*3)+1
    // loop equal to number
    let rand_spells = []
    for (let i = 0; i < number; i++) {
        let spell = spells[Math.floor(Math.random()*spells.length)]
        rand_spells.push(spell)
    }
    let target = event.source.player
    event.entity.lookAt("eyes",new Vec3d(target.x, target.y, target.z))
    newCast(event.entity, rand_spells, event.source.player, number, 'dutchrat_defensive')
})

EntityEvents.spawned('rats:dutchrat', event => {
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run time set midnight`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run weather thunder`)
    change_size(event.entity, 1.8)
    Utils.server.scheduleInTicks(140, () => {
        applyEffect(event.entity, 'minecraft:speed', 'infinite', 10, 'dutchrat_speed')
        Utils.server.scheduleInTicks(105, e => {
            if (!event.entity.alive) {
                e.repeating = false
                return
            } else {
                e.repeating = true
                let target = event.level.getNearestPlayer(event.entity, 100)
                if (target == null) return
                let spells = dutchrat_attack_spells1
                //choose a number between 1 and 3
                let number = Math.floor(Math.random()*3)+1
                // loop equal to number
                let rand_spells = []
                for (let i = 0; i < number; i++) {
                    let spell = spells[Math.floor(Math.random()*spells.length)]
                    rand_spells.push(spell)
                }
                event.entity.lookAt("eyes",new Vec3d(target.x, target.y, target.z))
                newCast(event.entity, rand_spells, target, number, 'dutchrat_attack')
            }
        })
        Utils.server.scheduleInTicks(20, e => {
            if (!event.entity.alive) {
                e.repeating = false
                return
            } else {
                e.repeating = true
                let target = event.level.getNearestPlayer(event.entity, 100)
                if (target == null) return
                event.entity.lookAt("eyes",new Vec3d(target.x, target.y+1, target.z))
                // 40% chance to cast a spell
                let chance = Math.random()
                if (chance > 0.4) return
                let spells = dutchrat_attack_spells2
                //choose a number between 1 and 3
                let number = Math.floor(Math.random()*3)+1
                // loop equal to number
                let rand_spells = []
                for (let i = 0; i < number; i++) {
                    let spell = spells[Math.floor(Math.random()*spells.length)]
                    rand_spells.push(spell)
                }
                event.entity.lookAt("eyes",new Vec3d(target.x, target.y, target.z))
                newCast(event.entity, rand_spells, target, number, 'dutchrat_attack2')
            }
        })
    })
    
})


let rat_baron_attack_spells = [
    'fireball 2',
    'lightning_lance 2',
]

let ratling_bullet_map =new WeakMap()
EntityEvents.spawned('rats:rattling_gun_bullet', event => {
    // 25% chance
    let box = AABB.of(event.entity.x+5, event.entity.y+5, event.entity.z+5, event.entity.x-5, event.entity.y-5, event.entity.z-5)
    let dim = event.level
    let uuid = ''
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(e => {
        if (e.type == 'rats:rat_baron') {
            uuid = e.uuid
        }
    })
    if (ratling_bullet_map[uuid] == undefined) {
        ratling_bullet_map[uuid] = 1
    } else {
        ratling_bullet_map[uuid]+=1
    }
    if (ratling_bullet_map[uuid] < 4) {
       event.cancel()
    } else {
        let motionx = event.entity.motionX
        let motiony = event.entity.motionY
        let motionz = event.entity.motionZ
        let missile = event.level.createEntity('irons_spellbooks:comet')
        missile.setPosition(event.entity.x, event.entity.y, event.entity.z)
        missile.setMotion(motionx, motiony, motionz)
        missile.mergeNbt({
            Damage: 5,
            ExplosionRadius: 5,
        })
        missile.spawn()
        ratling_bullet_map[uuid] = 0
        event.cancel()
    }
})

EntityEvents.spawned('rats:rat_baron', event => {
    if (event.level.dimension != 'rats:ratlantis') return
    event.entity.tags.add('baron')
    event.entity.persistentData.putString('dutchrat', event.server.persistentData.getString('dutchrat_uuid'))
    Utils.server.scheduleInTicks(100, e => {
        Utils.server.scheduleInTicks(45, e => {
            if (!event.entity.alive) {
                e.repeating = false
                event.entity.kill()
                return
            } else {
                e.repeating = true
                if (event.entity.distanceToEntity(event.level.getEntity(event.server.persistentData.getString('dutchrat_uuid'))) > 80) {
                    let dutchrat = event.level.getEntity(event.server.persistentData.getString('dutchrat_uuid'))
                    let vehicle = event.entity.rootVehicle
                    event.entity.teleportTo(event.server.persistentData.dutchrat_bell_dim, event.server.persistentData.dutchrat_bell_x, event.server.persistentData.dutchrat_bell_y+30, event.server.persistentData.dutchrat_bell_z, event.entity.yaw, event.entity.pitch)
                    vehicle.teleportTo(event.server.persistentData.dutchrat_bell_dim, event.server.persistentData.dutchrat_bell_x, event.server.persistentData.dutchrat_bell_y+30, event.server.persistentData.dutchrat_bell_z, vehicle.yaw, vehicle.pitch)
                    event.entity.startRiding(vehicle)
                }
                let target = event.level.getNearestPlayer(event.entity, 80)
                if (target == null) return
                event.entity.lookAt("eyes",new Vec3d(target.x, target.y, target.z))
                // 40% chance to cast a spell
                    let dim = event.level.dimension
                    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.entity.uuid} ${rat_baron_attack_spells[Math.floor(Math.random()*rat_baron_attack_spells.length)]}`)
                
            }
        })
    })
})




EntityEvents.spawned('rats:rat_baron_plane', event => {
    // give a permanent glowing effect
    Utils.server.scheduleInTicks(20, () => {
        Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:glowing infinite 1 true`)
    })
    
})

EntityEvents.spawned('rats:rat_baron', event => {
    // give a permanent glowing effect
    Utils.server.scheduleInTicks(10, () => {
        Utils.server.runCommandSilent(`/effect give ${event.entity.uuid} minecraft:glowing infinite 1 true`)
    })
    
})


let dutchrat_drops = [
    'rats:marbled_cheese_rat_head',
    'rats:gem_of_ratlantis',
    'rats:dutchrat_wheel'

]



EntityEvents.death('rats:dutchrat', event => {
    Utils.server.runCommandSilent(`/execute in ${event.entity.level.dimension} run kill @e[type=irons_spellbooks:comet]`)
    let server = event.server
    let x = Number(server.persistentData.getInt('dutchrat_bell_x'))
    let y = Number(server.persistentData.getInt('dutchrat_bell_y'))
    let z = Number(server.persistentData.getInt('dutchrat_bell_z'))
    let dim = event.server.persistentData.getString('dutchrat_bell_dim')
    Utils.server.scheduleInTicks(1, () => {
        dutchrat_drops.forEach(drop => {
            Utils.server.runCommandSilent(`/kill @e[type=item,nbt={Item:{id:"${drop}"}}]`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run summon item ${x} ${y+1} ${z} {Item:{id:"${drop}",Count:1b}}`)
        })
    })
    let players = event.level.entities.filter(e => e.player && e.distanceToEntity(event.entity) < 100)
    players.forEach(player => {
        Utils.server.runCommandSilent(`/execute in ${dim} run tp ${player.username} ${x} ${y} ${z}`)
        player.tags.remove('dutchrat_summoned')
        let subterranodon = player.level.getEntity(player.persistentData.getString('subterranodon_uuid'))
        Utils.server.runCommandSilent(`/kill ${subterranodon.uuid}`)
        player.persistentData.remove('subterranodon_uuid')
        player.persistentData.remove('dutchrat_summoned')
        server.persistentData.remove('dutchrat_bell_x')
        server.persistentData.remove('dutchrat_bell_y')
        server.persistentData.remove('dutchrat_bell_z')
        server.persistentData.remove('dutchrat_bell_dim')
        server.persistentData.remove('dutchrat_fight')
        server.persistentData.remove('dutchrat_uuid')

        //removeMinigun(player)
    })


})


/**
 * Removes every `cgm:mini_gun` from the given player—but **only** if the gun
 * is enchanted with Curse of Vanishing.
 *
 * @param {Internal.PlayerJS} player
 */
function removeMinigun(player) {
  let VANISHING = 'minecraft:vanishing_curse';

  // Helper to check for the curse
  let hasVanishing = (stack) =>
    (stack?.nbt?.Enchantments || [])
      .some(e => e.id === VANISHING);

  // ■ Scan the main inventory (hot-bar + backpack)
  for (let slot = 0; slot < player.inventory.containerSize; slot++) {
    let stack = player.inventory.getItem(slot);
    if (stack.empty || stack.id !== 'cgm:mini_gun') continue;

    if (hasVanishing(stack)) player.inventory.setItem(slot, Item.empty);
  }

  // ■ Clear cached hand stacks separately
  ['mainHandItem', 'offHandItem'].forEach(prop => {
    let stack = player[prop];
    if (stack.empty || stack.id !== 'cgm:mini_gun') return;

    if (hasVanishing(stack)) stack.count = 0;   // removes the item
  });
}
